#! /bin/sh

SERVER_ROOT="/opt/TrendMicro/Pixiebob/Server/"
SERVER_DATA_ROOT="${SERVER_ROOT}init/data/"
SERVER_CONF_ROOT="${SERVER_ROOT}init/config/"
INIT_PIXIEBOB_FLAG="${SERVER_ROOT}init/pixiebob_initialized.flag"
MIGRATE_FLAG="${SERVER_ROOT}init/migrate.flag"
PRE_UNINSTALL_LOG="${SERVER_ROOT}logs/pre_uninstall_server.log"
SSL_CERT_ROOT="/etc/nginx/ssl/"

SERVER_MODE="$(cat /opt/TrendMicro/Pixiebob/server_mode)"
############################################################
##               Deactivate Service                         ##
############################################################
deactivate_pixiebob_services() {
    # Check server mode
    echo "[`date`] Deactivate pixiebob services.." >> ${PRE_UNINSTALL_LOG} 2>&1
    echo "[`date`] Server mode:${SERVER_MODE}" >> ${PRE_UNINSTALL_LOG} 2>&1

    # Deactivate common services
    # Portal service
    if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
        systemctl stop pixiebob-portal >> ${PRE_UNINSTALL_LOG} 2>&1
        systemctl stop pixiebob-scheduler >> ${PRE_UNINSTALL_LOG} 2>&1
    fi
    systemctl disable pixiebob-portal >> ${PRE_UNINSTALL_LOG} 2>&1
    rm -f /usr/lib/systemd/system/pixiebob-portal.service >> ${PRE_UNINSTALL_LOG} 2>&1

    systemctl disable pixiebob-scheduler >> ${PRE_UNINSTALL_LOG} 2>&1
    rm -f /usr/lib/systemd/system/pixiebob-scheduler.service >> ${PRE_UNINSTALL_LOG} 2>&1

    case ${SERVER_MODE} in
      "ALL")  # All-in-one
          if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
              systemctl stop pixiebob-agent >> ${PRE_UNINSTALL_LOG} 2>&1
              systemctl stop pixiebob-resource >> ${PRE_UNINSTALL_LOG} 2>&1
          fi
          # Agent service
          systemctl disable pixiebob-agent >> ${PRE_UNINSTALL_LOG} 2>&1
          rm -f /usr/lib/systemd/system/pixiebob-agent.service >> ${PRE_UNINSTALL_LOG} 2>&1

          # Resource service
          systemctl disable pixiebob-resource >> ${PRE_UNINSTALL_LOG} 2>&1
          rm -f /usr/lib/systemd/system/pixiebob-resource.service >> ${PRE_UNINSTALL_LOG} 2>&1
          ;;

      "UC")  # UC server only
         
          if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
              systemctl stop pixiebob-agent >> ${PRE_UNINSTALL_LOG} 2>&1
          fi
          # Agent service
          systemctl disable pixiebob-agent >> ${PRE_UNINSTALL_LOG} 2>&1
          rm -f /usr/lib/systemd/system/pixiebob-agent.service >> ${PRE_UNINSTALL_LOG} 2>&1
          ;;

      "UCLR") # UC Local Repo only
          if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
              systemctl stop pixiebob-resource >> ${PRE_UNINSTALL_LOG} 2>&1
          fi

          # Resource service
          systemctl disable pixiebob-resource >> ${PRE_UNINSTALL_LOG} 2>&1
          rm -f /usr/lib/systemd/system/pixiebob-resource.service >> ${PRE_UNINSTALL_LOG} 2>&1
          ;;

      "UCRR") # UC Remote Repo only 
          if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
              systemctl stop pixiebob-resource >> ${PRE_UNINSTALL_LOG} 2>&1
          fi

          # Resource service
          systemctl disable pixiebob-resource >> ${PRE_UNINSTALL_LOG} 2>&1
          rm -f /usr/lib/systemd/system/pixiebob-resource.service >> ${PRE_UNINSTALL_LOG} 2>&1
          ;;

      *) # Should not happen
          echo "[`date`] [ERROR] Invalid install type." >> ${PRE_UNINSTALL_LOG} 2>&1
          ;;
    esac

}


deactivate_system_services() {
    echo "[`date`] Deactivate system services." >> ${PRE_UNINSTALL_LOG} 2>&1
    if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
        systemctl stop nginx
        systemctl stop postgresql-9.6
    fi

    # Nginx
    systemctl disable nginx  >> ${PRE_UNINSTALL_LOG} 2>&1
    /usr/bin/rm -f /etc/nginx/conf.d/default*.conf

    # Posstgresql
    systemctl disable postgresql-9.6  >> ${PRE_UNINSTALL_LOG} 2>&1
}

############################################################
##               UnInstall pbagent                          ##
############################################################
uninstall_pbagent() {
    echo "[`date`] UnInstall LR agent." >> ${PRE_UNINSTALL_LOG} 2>&1
    cd /opt/TrendMicro/Pixiebob/Agent/manipulation
    ./setup.sh -psqluser postgres -psqldb postgres -path /opt/TrendMicro/Pixiebob/Agent -uninstall >> ${PRE_UNINSTALL_LOG} 2>&1

    echo "[`date`] UnInstall result:$?" >> ${PRE_UNINSTALL_LOG} 2>&1
}


drop_db(){
    echo "[`date`] Drop pixiebob database" >> ${PRE_UNINSTALL_LOG} 2>&1
    /usr/pgsql-9.6/bin/dropdb pixiebob -h 127.0.0.1 -U pixiebob  >> ${PRE_UNINSTALL_LOG} 2>&1     

    echo "[`date`] Drop user pixiebob"  >> ${PRE_UNINSTALL_LOG} 2>&1
    /usr/pgsql-9.6/bin/dropuser -h 127.0.0.1 -U postgres pixiebob  >> ${PRE_UNINSTALL_LOG} 2>&1
    
}


# Main logic
if [ ! -f ${MIGRATE_FLAG} ]; then
    echo "[`date`] Uninstall case" >> ${PRE_UNINSTALL_LOG} 2>&1
    if test -e "${SERVER_ROOT}api/resource/VAReport"; then rm -rf "${SERVER_ROOT}api/resource/VAReport"; fi

    deactivate_pixiebob_services

    # Uninstall LR agent in UCLR mode
    if [ ${SERVER_MODE} == "UCLR" ]; then
        uninstall_pbagent
    fi

    # Drop database
    drop_db

    deactivate_system_services

    # Remove ssl certificates
    echo "[`date`] Remove SSL certificates.."  >> ${PRE_UNINSTALL_LOG} 2>&1

    /usr/bin/rm -rf ${SSL_CERT_ROOT}    

    # Remove product version
    rm -f /etc/sysconfig/product_env
    rm -f /etc/profile.d/product.sh

    # Remove flag
    echo "[`date`] Remove init flags" >> ${PRE_UNINSTALL_LOG} 2>&1
    /usr/bin/rm -f ${INIT_PIXIEBOB_FLAG}

    # Remove ckp packages
    rm -rf ${SERVER_ROOT}api/third_party_int/ckp/*
else
    echo "[`date`] Migrate case, skip." >> ${PRE_UNINSTALL_LOG} 2>&1
    echo "[`date`] Remove migrate flag" >> ${PRE_UNINSTALL_LOG} 2>&1
    /usr/bin/rm -f ${MIGRATE_FLAG}
fi




